/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_SysTime.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    Standardized definitions of SysTime Module

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-23  File created.

**************************************************************************************/


#ifndef __AP_SYSTIME_H
#define __AP_SYSTIME_H

#ifdef __cplusplus
extern "C" {
#endif

// Systime TimeStamp structure contains Nanoseconds and *Seconds*.
// The meaning of Seconds is influenced by the NETX_SYS_TIME_NS_BOR register.

typedef struct SYSTIME_TIMESTAMP_Ttag
{
  UINT32 ulTimeNs;
  UINT32 ulTimeS;
} SYSTIME_TIMESTAMP_T;


RX_RESULT             Drv_SysTimeSetTime                  (SYSTIME_TIMESTAMP_T FAR*         ptTimeStamp);
void                  Drv_SysTimeGetTime                  (SYSTIME_TIMESTAMP_T FAR*         ptTimeStamp);

void                  Drv_SysTimeSetSysTimeBorder         (UINT32                           ulSystimeBorder);
UINT32                Drv_SysTimeGetSysTimeBorder         (void);

void                  Drv_SysTimeSetSysTimeCountValue     (UINT32                           ulSystimeCountVal);
UINT32                Drv_SysTimeGetSysTimeCountValue     (void);

RX_RESULT             Drv_SysTimeAddTime                  (const SYSTIME_TIMESTAMP_T FAR*   ptTimestamp,
                                                           UINT32                           ulAddTime_s,
                                                           UINT32                           ulAddTime_ns,
                                                           SYSTIME_TIMESTAMP_T FAR*         ptTimestampSum);

int                   Drv_SysTimeCompareSystime           (SYSTIME_TIMESTAMP_T FAR*         ptTimestamp);

int                   Drv_SysTimeCompareTimestamps        (const SYSTIME_TIMESTAMP_T FAR*   ptTimestampA,
                                                           const SYSTIME_TIMESTAMP_T FAR*   ptTimestampB);

RX_RESULT             Drv_SysTimeGetTimestampDifference   (const SYSTIME_TIMESTAMP_T FAR*   ptTimestampA,
                                                           const SYSTIME_TIMESTAMP_T FAR*   ptTimestampB,
                                                           SYSTIME_TIMESTAMP_T FAR*         ptTimestampResult,
                                                           int *                            piCompareResult);

INLINE UINT64 Drv_SysTimeConvertTimestampToTime(SYSTIME_TIMESTAMP_T FAR* ptTimestamp)
{
  UINT64 ullTime = ptTimestamp->ulTimeS;
  ullTime *= (((UINT64)Drv_SysTimeGetSysTimeBorder())+1);
  return ullTime+ptTimestamp->ulTimeNs;
}

#ifdef __cplusplus
}
#endif

#endif  // __systime__
